in vec2 TexCoord;
out vec4 FragColor;

uniform sampler2D InputTexture;
uniform float InvGamma;
uniform float Contrast;
uniform float Brightness;
uniform float Saturation;

void main() {
	vec4 c = texture(InputTexture, TexCoord);
	vec3 valgray = mix(vec3(dot(c.rgb, vec3(0.3, 0.56, 0.14))), c.rgb, Saturation);
	vec3 val = Brightness + valgray * Contrast - (Contrast - 1.0) * 0.5;
	val = pow(max(val, vec3(0.0)), vec3(InvGamma));
	FragColor = vec4(val, c.a);
}