#ifdef SHADER_PASS_LIGHTS
vec2 lightAttenuation(int i, vec3 normal, vec3 viewdir, float lightcolorA) {
	vec4 lightpos = lights[i];
	vec3 lightDir = lightpos.xyz - pixelpos.xyz; // Precompute direction
	float lightdistance = length(lightDir);
	if(lightdistance < lightpos.w) { // Early out lights touching surface but not this fragment
		vec4 lightspot1 = lights[i + 2];
		float attenuation = (lightpos.w - lightdistance) / lightpos.w;
		if(lightspot1.w > 0.0) { attenuation *= smoothstep(lightspot1.w, 1.f, dot(normalize(lightDir), lightspot1.xyz)); }
		if(lightcolorA < 0.0) { attenuation *= max(dot(normal, normalize(lightDir)), 0.0); } // Sign bit is the attenuated light flag
#ifdef SHADER_PASS_SHADOWMAPS
		if(attenuation > 0.0) { attenuation *= shadowAttenuation(lightpos, lightcolorA); } // Skip shadow map test if possible
#endif
		if(attenuation > 0.0) {
			float glossiness = uSpecularMaterial.x;
			float specularLevel = uSpecularMaterial.y;
			vec3 halfdir = normalize(viewdir + lightDir);
			float specAngle = clamp(dot(halfdir, normal), 0.0f, 1.0f);
			float phExp = glossiness * 4.0f;
			return vec2(attenuation, attenuation * specularLevel * pow(specAngle, phExp));
		}
	}
	return vec2(0.0);
}
#endif

vec3 ProcessMaterialLight(Material material, vec3 color) {
	vec3 specular = vec3(0.0);
#ifdef SHADER_PASS_LIGHTS
	vec3 normal = material.Normal;
	vec3 viewdir = normalize(uCameraPos.xyz - pixelpos.xyz);
	if(uLightGroupStart >= 0) {
		// modulated lights
		for(int i = uLightGroupStart; i < uLightGroupEnd; i += 3) {
			vec4 lightcolor = lights[i + 1];
			vec2 attenuation = lightAttenuation(i, normal, viewdir, lightcolor.a);
			color += lightcolor.rgb * attenuation.x;
			specular += lightcolor.rgb * attenuation.y;
		}
	}
#endif
	return material.Base.rgb * clamp(desaturateRGB(color), 0.0, 1.4) + material.Specular * clamp(desaturateRGB(specular), 0.0, 1.4);
}