vec3 ProcessMaterialLight(Material material, vec3 color) {
	vec3 normal = material.Normal;
#ifdef SHADER_PASS_LIGHTS
	if(uLightGroupStart >= 0) {
		// modulated lights
		for(int i = uLightGroupStart; i < uLightGroupEnd; i += 3) {
			vec4 lightpos = lights[i];
            vec3 lightDir = lightpos.xyz - pixelpos.xyz; // Precompute direction
			float lightdistance = length(lightDir);
			if(lightdistance < lightpos.w) { // Early out lights touching surface but not this fragment
				vec4 lightcolor = lights[i + 1];
				vec4 lightspot1 = lights[i + 2];
				float attenuation = (lightpos.w - lightdistance) / lightpos.w;
				if(lightspot1.w > 0.0) {
					// [Sherbet] gross float hack here, shouldn't matter that much, see gl_lightbuffer.cpp for the other end of this
					// smoothstep(mod(lightData, 8192.f), lightData / 8192.f, cosDir);
					attenuation *= smoothstep(lightspot1.w, 1.f, dot(normalize(lightDir), lightspot1.xyz));
				}
				if(lightcolor.a < 0.0) { attenuation *= max(dot(normal, normalize(lightDir)), 0.0); } // Sign bit is the attenuated light flag
#ifdef SHADER_PASS_SHADOWMAPS
				if(attenuation > 0.0) { attenuation *= shadowAttenuation(lightpos, lightcolor.a); } // Skip shadow map test if possible
#endif
				color += lightcolor.rgb * attenuation;
			}
		}
	}
#endif
	return material.Base.rgb * clamp(desaturateRGB(color), 0.0, 1.4);
}