in vec2 TexCoord;
out vec4 FragColor;
uniform sampler2D DepthTexture;
uniform sampler2D ColorTexture;
uniform float LinearizeDepthA;
uniform float LinearizeDepthB;
uniform vec2 Scale;
uniform vec2 Offset;

void main() {
	vec2 uv = Offset + TexCoord * Scale;
	ivec2 texSize = textureSize(DepthTexture, 0);
	ivec2 ipos = ivec2(max(uv * vec2(texSize), vec2(0.0)));
	float depth = 1.0 / (clamp(texelFetch(ColorTexture, ipos, 0).a != 0.0 ? texelFetch(DepthTexture, ipos, 0).x : 1.0, 0.0, 1.0) * LinearizeDepthA + LinearizeDepthB);
	FragColor = vec4(depth, 0.0, 0.0, 1.0);
}