in vec2 TexCoord;
out vec4 FragColor;
uniform sampler2D ExposureTexture;

void main() {
#ifdef VGX_OPENGL_ES
	// Calculate the texel size for proper offset
	vec2 texelSize = vec2(1.0) / vec2(textureSize(ExposureTexture, 0));

	// Manually sample the four texels around the given texture coordinate
	vec4 value1 = texture(ExposureTexture, TexCoord + vec2(-0.5, -0.5) * texelSize);
	vec4 value2 = texture(ExposureTexture, TexCoord + vec2( 0.5, -0.5) * texelSize);
	vec4 value3 = texture(ExposureTexture, TexCoord + vec2(-0.5,  0.5) * texelSize);
	vec4 value4 = texture(ExposureTexture, TexCoord + vec2( 0.5,  0.5) * texelSize);

	// Average the four sampled values
	FragColor = vec4((value1.r + value2.r + value3.r + value4.r) * 0.25, 0.0, 0.0, 1.0);
#else
	vec4 values = textureGather(ExposureTexture, TexCoord);
	FragColor = vec4((values.x + values.y + values.z + values.w) * 0.25, 0.0, 0.0, 1.0);
#endif
}